@extends("frontend.layout")

@section("body")
  <main class="main">

    <!-- Page Title -->
    <div class="page-title" data-aos="fade" style="background-image: url(assets/img/coverpage/gallery.jpeg);">
      <div class="container position-relative">
        <h1>Gallery</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="{{route('index')}}">Home</a></li>
            <li class="current">Gallery</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- Services Section -->
    <section id="services" class="services section">

      <div class="container">

        <div class="row gy-4">

          @foreach ($galleries as $gallery)
            
            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
              <div class="service-item  position-relative"> 
                <h3>{{$gallery->name}}</h3>
                <img src="{{asset($gallery->pic)}}" class="img-fluid" alt="">
                <p></p> 
                <a href="{{route('get.product', $gallery->producttype->slug)}}" class="readmore stretched-link">view more <i class="bi bi-arrow-right"></i></a>
              </div>
            </div><!-- End Service Item --> 
          @endforeach 
        </div>

      </div>

    </section><!-- /Services Section -->

    

  </main>
@endsection