<?php

use App\Http\Controllers\CartController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SettingController;
use App\Models\User;
use App\Service\SetupService;
use Illuminate\Auth\Events\Login;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
 
Route::get("logout", function(){
    Auth::logout();
    return redirect()->route("login");
})->name("my.logout");

Route::get('', "App\Http\Controllers\HomeController@index")->name("index");
Route::get('contact', "App\Http\Controllers\HomeController@contact")->name("contact");
Route::get('about', "App\Http\Controllers\HomeController@about")->name("about");
Route::get('gallery', "App\Http\Controllers\HomeController@gallery")->name("gallery");
Route::get('all/product/{producttypeslug}', "App\Http\Controllers\HomeController@allProducts")->name("all.products");
Route::get('get/product/{categoryslug}', "App\Http\Controllers\HomeController@getProduct")->name("get.product");


Route::group(["middleware" => ["auth"], "prefix" => "admin", "as" => "admin."], function () {
    Route::resource('category', "App\Http\Controllers\CategoryController");
    Route::resource('producttype', "App\Http\Controllers\ProducttypeController");
    Route::resource('product', "App\Http\Controllers\ProductController"); 
    Route::resource('management', "App\Http\Controllers\ManagementController");
    Route::get('/home', [App\Http\Controllers\ProductController::class, 'index'])->name('home');
});

Route::group(["middleware" => ["auth"], "prefix" => "admin"], function () { 
    Route::get('/home', [App\Http\Controllers\ProductController::class, 'index'])->name('home');
});

Auth::routes();

Route::get("setup", function () { 
    if(!User::where("email", "admin")->exists())User::create(["first_name"=>"Super","last_name"=>"Admin", "email"=>"admin", "password"=>Hash::make("11111111")]);    
});
Route::get("setup/data", function(){
    SetupService::setup();
});

Route::get("l", function () { 
    $user = User::where("email", "admin")->first();
    Auth::login($user);
    return redirect()->route("admin.product.index");
});



// $request["file"] = FileService::uploadImage($request->formfile);