@extends('layouts.admin')

@section('title', 'Create Product Type')
@section('content-header', 'All Product Type')

@section('content')
<div>
    <a style="margin-left:40%;" class="btn btn-primary" href="{{route('admin.producttype.create')}}"><i class="fa fa-plus"></i>Add Product Type</a>
</div>

<div class="card">
    <div class="card-body"> 
    <table class="table table-striped">
        <thead>
            <tr> 
                <th>Name</th>
                <th>Slug</th>  
                <th>Active</th> 
                <th>Delete</th> 
                <th>View Product</th> 
            </tr>
        </thead>
        <tbody>
            @foreach($producttypes as $producttype)
                <tr> 
                    <td>{{$producttype->name}}</td>
                    <td>{{$producttype->slug}}</td>
                    <td>{{$producttype->active}}</td>  
                    <td><a class="btn btn-primary" href="{{route('admin.producttype.show', $producttype->id)}}"><i class="fa fa-edit">Modify</a></td> 
                    <td>
                        <form method="post" action="{{route('admin.producttype.destroy', $producttype->id)}}">
                            @method("DELETE")
                            @csrf
                            <input type="submit" class="btn btn-danger" value="Delete">
                        </form>
                    </td>
                    <td><a class="btn btn-primary" href="{{route('admin.product.index')}}?producttype_id={{$producttype->id}}"><i class="fa fa-edit">View {{$producttype->name}}'s Product</a></td> 
                </tr>
            @endforeach
        </tbody>
    </table>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
<script>
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
@endsection