@extends('layouts.admin')

@section('title', 'Create Product Type')
@section('content-header', 'Create Product Type')

@section('content')

<div class="card">
    <div class="card-body">
	<!-- Log on to codeastro.com for more projects -->
    <form style="width:50%;margin-left:25%;" action="{{route('admin.producttype.store')}}" enctype='multipart/form-data' method="POST" class="needs-validation" novalidate>
        @csrf    
        <div class="form-group">
            <label for="duration">Category:</label>
            <select class="form-control" id="category_id" required name="category_id">
                <option value="">-- Select a Category --</option>
                @foreach ($categories as $category)
                    <option value="{{$category->id}}">
                        {{$category->name}}
                    </option>
                @endforeach
            </select>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>     
        <div class="form-group">
            <label for="duration">Name:</label>
            <input type="text" class="form-control" id="name" placeholder="Product Type" name="name" required>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>     
        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i>Submit</button>
    </form>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
<script>
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
@endsection
