@extends('layouts.admin')

@section('title', 'Create Product')
@section('content-header', 'All Product')

@section('content')
<div>
    <a style="margin-left:40%;" class="btn btn-primary" href="{{route('admin.product.create')}}"><i class="fa fa-plus"></i>Add Product</a>
</div>

<div class="card">
    <div class="card-body"> 
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Product Type</th>
                <th>Name</th>
                <th>Pic</th>
                <th>Slug</th> 
                <th>status</th> 
                <th>Delete</th> 
            </tr>
        </thead>
        <tbody>
            @foreach($products as $product)
                @php
                    if(strpos($product->pic, '.mp4') !== false ){ 
                        continue;
                    }
                    $color = $product->active == 0 ? "danger":"success";
                @endphp
                <tr>
                    <td class="text-{{$color}}">{{$product->producttype->name}}</td>
                    <td class="text-{{$color}}"> 
                        @if($product->pic && strlen($product->pic) > 0)
                            <img src='{{asset("$product->pic")}}' width="70px" height="70px" style="border-radius:50%">
                        @else
                            No Logo Found
                        @endif
                    </td>
                    <td class="text-{{$color}}">{{$product->name}}</td>
                    <td class="text-{{$color}}">{{$product->slug}}</td>
                    <td class="text-{{$color}}">{{$product->active}}</td>
                    <td><a class="btn btn-primary" href="{{route('admin.product.show', $product->id)}}"><i class="fa fa-edit">Modify</a></td> 
                        <td>
                            <form method="post" action="{{route('admin.product.destroy', $product->id)}}">
                                @method("DELETE")
                                @csrf
                                <input type="submit" class="btn btn-danger" value="Delete">
                            </form>
                        </td> 
                </tr>
            @endforeach
        </tbody>
    </table>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
<script>
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
@endsection