@extends('layouts.admin')

@section('title', 'Create Product')
@section('content-header', 'Modify Product')

@section('content')

<div class="card">
    <div class="card-body">
	<!-- Log on to codeastro.com for more projects -->
    <img src="{{asset($product->pic)}}" width="200px" height="200px" style="margin-left:40%;" /><br>
    <form style="width:50%;margin-left:25%;" action="{{route('admin.product.update', $product->id)}}" method="POST" enctype='multipart/form-data' class="needs-validation" novalidate>
        @csrf
        @method("put")
        <div class="form-group">
            <label for="status">Product Type *:</label>
            <select class="form-control" id="producttype_id"  name="producttype_id" required>
                <option value="">Select Product Type</option>
                @foreach ( $producttypes as $producttype )
                    <option {{$product->producttype_id == $producttype->id ? "selected":""}} value="{{$producttype->id}}">{{$producttype->name}}</option>                                        
                @endforeach
            </select>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div> 
        <div class="form-group">
            <label for="duration">Name:</label>
            <input type="text" class="form-control" value="{{$product->name}}" id="name" placeholder="Product Name" name="name" required>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>        
        <div class="form-group">
            <label for="duration">Image:</label>
            <input type="file" class="form-control" id="formpic" accept="image/*" name="formpic" required>
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div>      
        <div class="form-group">
            <label for="home">Show On Home Page:</label>
            <input type="checkbox" {{$product->home ==1 ? "checked":""}} value="1" id="home" name="home">
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div> 
         
        <div class="form-group">
            <label for="duration">Active:</label>
            <input type="checkbox" {{$product->active ==1 ? "checked":""}} value="1" id="active" name="active">
            <div class="valid-feedback">Valid.</div>
            <div class="invalid-feedback">Please fill out this field.</div>
        </div> 
        
        <button type="submit" class="btn btn-primary"><i class="fa fa-edit"></i>Modify</button>
    </form>
    
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
<script>
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
@endsection