@extends('layouts.admin')

@section('title', 'Create Management')
@section('content-header', 'All Management')

@section('content')
<div>
    <a style="margin-left:40%;" class="btn btn-primary" href="{{route('admin.management.create')}}"><i class="fa fa-plus"></i>Add Management</a>
</div>

<div class="card">
    <div class="card-body"> 
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Name</th>
                <th>Image</th> 
                <th>Postion</th>
                <th>Facebook</th>
                <th>Twitter</th> 
                <th>Instagram</th>
                <th>Linkedin</th> 
                <th>Status</th> 
            </tr>
        </thead>
        <tbody>
            @foreach($managements as $management)
                <tr>
                    <td>{{$management->name}}</td>
                    <td>
                        @if(!empty($management->image))
                            <img src="{{asset($management->image)}}" style="width: 80px; height: 100px"></td>
                        @else
                            No Image
                        @endif
                    <td>{{$management->post}}</td>
                    <td>{{$management->facebook}}</td>
                    <td>{{$management->twitter}}</td> 
                    <td>{{$management->instagram}}</td>
                    <td>{{$management->linkedin}}</td> 
                    <td>{{$management->active}}</td>
                    <td><a class="btn btn-primary" href="{{route('admin.management.show', $management->id)}}"><i class="fa fa-edit">Modify</a></td> 
                </tr>
            @endforeach
        </tbody>
    </table>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
<script>
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
@endsection