@extends('layouts.admin')

@section('title', 'Create Category')
@section('content-header', 'All Category')

@section('content')
<div>
    <a style="margin-left:40%;" class="btn btn-primary" href="{{route('admin.category.create')}}"><i class="fa fa-plus"></i>Add Category</a>
</div>

<div class="card">
    <div class="card-body"> 
    <table class="table table-striped">
        <thead>
            <tr> 
                <th>Name</th>
                <th>Slug</th>  
                <th>Active</th> 
                <th>Delete</th> 
                <th>View Product</th> 
            </tr>
        </thead>
        <tbody>
            @foreach($categories as $category)
                <tr> 
                    <td>{{$category->name}}</td>
                    <td>{{$category->slug}}</td>
                    <td>{{$category->active}}</td>  
                    <td><a class="btn btn-primary" href="{{route('admin.category.show', $category->id)}}"><i class="fa fa-edit">Modify</a></td> 
                    <td>
                        <form method="post" action="{{route('admin.category.destroy', $category->id)}}">
                            @method("DELETE")
                            @csrf
                            <input type="submit" class="btn btn-danger" value="Delete">
                        </form>
                    </td>
                    <td><a class="btn btn-primary" href="{{route('admin.product.index')}}?category_id={{$category->id}}"><i class="fa fa-edit">View {{$category->name}}'s Product</a></td> 
                </tr>
            @endforeach
        </tbody>
    </table>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
<script>
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
@endsection