<?php
namespace App\Service;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Http;
use Carbon\Carbon;

class FileService{
    public static function uploadImage($image, $category = "uncategorized", $folder = 'uploaded_image') {     
        if ($image) {   
            $originalName = pathinfo($image->getClientOriginalName(), PATHINFO_FILENAME);
            $extension = $image->getClientOriginalExtension();
     
            $randomValue = rand(10000, 99999); 
     
            $name = $originalName . '_' . $randomValue . '.' . $extension;
     
            $uploadingfolder = $folder . "/" . $category;  
             
            if (!file_exists(public_path($uploadingfolder))) {
                mkdir(public_path($uploadingfolder), 0755, true);
            }
     
            $image->move($uploadingfolder, $name); 
     
            return $uploadingfolder . "/" . $name; 
        }
    
        return "";
    }
    

    public static function removeImage($url){
    
        $urlArray = explode(".com/", $url); //Remove the url e.g traisoft.com
        $path = public_path($urlArray[1]); //construct path to where the file is on the server
    
        if(file_exists($path)){
            unlink($path); 
        }
        
        try{
            $pathArray = explode("/", $path); 
            array_pop($pathArray);
            $folder = implode("/", $pathArray);
            rmdir($folder);
            return "Deleted Successfully";
        }catch(\Exception $e){
    
        }
        
        return "";
    }
    
}  
?>