<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;
    protected $fillable = [
        'category_id',
        'producttype_id',
        'name',
        'slug',
        'pic',
        'home',
        'active'
    ];
 
    public function producttype(){
        return $this->belongsTo(Producttype::class, 'producttype_id');
    }
    
    public function category(){
        return $this->belongsTo(Category::class, 'category_id');
    }
}
