<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Producttype;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ProducttypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $producttypes = Producttype::with(["category"])->orderBy("active", "desc")->get();
        return view("producttype.index", compact("producttypes"));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    { 
        $categories = Category::where("active", 1)->get(); 
        return view("producttype.create", compact("categories"));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [ 
            'category_id' => "required",
            'name' => "required" 
        ]);

        $request["active"] = 1;
        $request["slug"] = Str::slug($request->name).rand(10000, 99999);
        if(Producttype::where("slug", $request["slug"])->exists())return redirect()->back()->with("error", "Product Type Already Exists");
        
        Producttype::create($request->all());
        return redirect()->route("admin.producttype.index")->with("success", "Product Type Created Successfully");

    }

     
    public function show(producttype $producttype)
    {
        $producttype = Producttype::where("id", $producttype->id)->first();
        return view("producttype.edit", compact("producttype"));
    }

    

    public function update(Request $request, producttype $producttype)
    {
        $this->validate($request, [ 
            'name' => "required" 
        ]);
        $request["active"] = $request->active == 1 ? 1 : 0;
        $newSlug = Str::slug($request->name);
        if($request->name == $producttype->name || !Product::where("slug", $newSlug)->exists()){
            $request["slug"] = $newSlug;
        }else{
            $request["slug"] = $newSlug.rand(100000, 999999);
        } 

        Producttype::where("id", $producttype->id)->update($request->only(["name", "slug", "active"]));
        return redirect()->route("admin.producttype.index")->with("success", "Product Type Updated Successfully");
    }


    public function destroy(Producttype $producttype)
    {
        if(Product::where("producttype_id", $producttype->id)->exists())return redirect()->back()->with("error", "Product Type Has Some Products Under It");        
        Producttype::where("id", $producttype->id)->delete();
        return redirect()->back() -> with("success", " Product Type Was Deleted Successfully");
    }
}
