<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;
use App\Models\Management;
use App\Models\Producttype;
use App\Service\UtilityService;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{ 
    public function index()
    {
        $categories = Category::where("active", 1)->get();
        $products = Product::with(["category"])->where("active", 1)->where("home", 1)->get();
        $galleries = Product::where("active", 1)->where("home", 0)->limit(24)->get();
        $managements = Management::where("active", 1)->get();
        $tiles = UtilityService::getProductType("tiles");
        $wares = UtilityService::getProductType("wares"); 
        return view("frontend.index", compact("categories", "products", "galleries", "managements", "tiles", "wares"));
    }
    
    public function gallery()
    {
        $categories = Category::where("active", 1)->get();
        $products = Product::with(["category"])->where("active", 1)->where("home", 1)->get();
        $galleries = Product::with(["producttype"])->where("active", 1)
                    ->where("home", 0)->get();
        $managements = Management::where("active", 1)->get();
        $tiles = UtilityService::getProductType("tiles");
        $wares = UtilityService::getProductType("wares"); 
        return view("frontend.gallery", compact("categories", "products", "galleries", "managements", "tiles", "wares"));
    }
        
    
    public function allProducts(Request $request, $slug)
    { 
        $products = DB::table("producttypes as pt")
                    ->join("products as p", "pt.id", "p.producttype_id")
                    ->where("pt.slug", $slug)
                    ->where("p.active", 1)
                    ->select("p.pic", "p.name", "pt.slug")
                    ->get();

        $category = DB::table("producttypes as pt")
                    ->join("categories as c", "c.id", "pt.category_id")
                    ->where("pt.slug", $slug) 
                    ->where("c.active", 1)
                    ->select("c.*")
                    ->first();
        // dd($category); 
        $producttypes = Producttype::where("active", 1)->get(); 
        $producttype = Producttype::where("slug", $slug)->first();
        $categories = Category::where("active", 1)->get();
        $tiles = UtilityService::getProductType("tiles");
        $wares = UtilityService::getProductType("wares"); 
        return view("frontend.products", compact("products", "categories", "producttype", "producttypes", "tiles", "wares"));
    }
 
    public function getProduct(Request $request, $slug)
    { 
        $products = DB::table("categories as c")
                    ->join("producttypes as pt", "c.id", "pt.category_id")
                    ->join("products as p", "pt.id", "p.producttype_id")
                    ->where("c.slug", $slug)
                    ->where("p.active", 1)
                    ->select("p.pic", "p.name", "pt.slug")
                    ->get();
                    
        $producttypes = Producttype::where("active", 1)->get();
        $categories = Category::where("active", 1)->get();
        $category = Category::where("slug", $slug)->first();
        $category_producttypes = Producttype::where("category_id", $category->id ?? 0)->get(); 
        $tiles = UtilityService::getProductType("tiles");
        $wares = UtilityService::getProductType("wares"); 
        return view("frontend.getproduct", compact("products", "categories", "category", "category_producttypes", "producttypes", "tiles", "wares"));
    }

    public function contact()
    {
        $categories = Category::where("active", 1)->get();
        $tiles = UtilityService::getProductType("tiles");
        $wares = UtilityService::getProductType("wares"); 
        return view("frontend.contact", compact("categories", "tiles", "wares"));
    }
    
    public function about()
    {
        $categories = Category::where("active", 1)->get();
        $tiles = UtilityService::getProductType("tiles");
        $wares = UtilityService::getProductType("wares"); 
        return view("frontend.about", compact("categories", "tiles", "wares"));
    }

}
