<?php

namespace App\Http\Controllers;

use App\Models\gallery;
use App\Models\User\product;
use App\Models\producttype;
use Illuminate\Http\Request;

class GalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $gallerys = Gallery::with("produc", "producttype");
        return view("gallery.index", compact("gallerys"));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $products = Product::get();
        $producttype = Producttype::get();
        return view("gallery.create", compact("product", "producttype"));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'product_id' => "required",
            'producttype_id' => "required",
            'image' => "required",
            'title' => "required",
            'description' => "required"
        ]);

        $request["active"] = 1; 
        Gallery::create($request->all());
        return redirect()->route("admin.gallery.index")->with("success", "Gallery Created Successfully");
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function show(gallery $gallery)
    {
        $products = Product::get();
        $producttype = Producttype::get();
        return view("gallery.edit", compact("product", "producttype"));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function edit(gallery $gallery)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, gallery $gallery)
    {
        $this->validate($request, [
            'product_id' => "required",
            'producttype_id' => "required",
            'image' => "required",
            'title' => "required",
            'description' => "required"
        ]);

        $request["active"] = $request->active == 1 ? 1 : 0;
        Gallery::where("id", $gallery->id)->update($request->only(["product_id", "producttype_id", "image", "title", "description"]));
        return redirect()->route("admin.gallery.index")->with("success", "Gallery Updated Successfullly");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\gallery  $gallery
     * @return \Illuminate\Http\Response
     */
    public function destroy(gallery $gallery)
    {
        //
    }
}
