<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use App\Models\Producttype;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CategoryController extends Controller
{
     
    public function index()
    {  
        $categories = Category::orderBy("active", "desc")->get(); 
        return view("category.index", compact("categories"));
    }
 
    public function create()
    { 
        return view("category.create");
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => "required" 
        ]);

        $request["active"] = 1; 
        $request["slug"] = Str::slug($request->name).rand(10000, 99999); 

        Category::create($request->all());
        return redirect()->route("admin.category.index")->with("success", "category created successfully");

    }

    public function show(category $category)
    { 
        return view("category.edit", compact("category"));
    }
     
    
    public function update(Request $request, category $category)
    { 
        $this->validate($request, [
            'name' => "required" 
        ]);
        $request["active"] = $request->active == 1 ? 1 : 0; 
        $newSlug = Str::slug($request->name);
        if($request->name == $category->name || !Category::where("slug", $newSlug)->exists()){
            $request["slug"] = $newSlug;
        }else{
            $request["slug"] = $newSlug.rand(100000, 999999);
        }  
        $arr = $request->only(["name", "slug", "active"]);
 
        Category::where("id", $category->id)->update($arr);
        return redirect()->route("admin.category.index")->with("success", " Category Updated Successfully");

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\category  $category
     * @return \Illuminate\Http\Response
     */
    public function destroy(Category $category)
    {
        if(Product::where("category_id", $category->id)->exists())return redirect()->back()->with("error", "Category Has Some Products Under It");
        Producttype::where("category_id", $category->id)->delete();
        Category::where("id", $category->id)->delete();
        return redirect()->back() -> with("success", " Category Was Deleted Successfully");
    }
}
